# __init__.py
# Copyright 2011 Roger Marsh
# Licence: See LICENCE (BSD licence)

"""Identify and initialise help_ as a sub-package in chesscalc."""

import os

ABOUT = "About"
NOTES = "Notes"

_textfile = {
    ABOUT: ("aboutcalculator",),
    NOTES: ("calculator",),
}

# Usually help files are in .../site_packages/chesscalc/help but when running
# an executable generated by py2exe installed by Inno installer this module
# is in .../ChessPerfCalc/library.zip/results while the help files are in
# .../ChessPerfCalc/help
folder = os.path.dirname(__file__).replace(
    os.path.join("ChessPerfCalc", "library.zip", "chesscalc"), "ChessPerfCalc"
)

for k in list(_textfile.keys()):
    _textfile[k] = tuple(
        os.path.join(folder, ".".join((n, "txt"))) for n in _textfile[k]
    )

del folder, k, os
